package com.xxfc.platform.uccn.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @author libin
 * @version 1.0
 * @description 友情连接
 * @data 2019/9/6 10:40
 */

@Data
@Entity
@Table(name = "friend_link")
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor

public class FriendLink implements Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(generator = "JDBC")
    private Long id;
    /**
     * 连接地址
     */
    @Column(name = "link_url")
    private String linkUrl;
    /**
     * 名称
     */
    private String name;
    /**
     * 简要说明
     */
    private String brief;
    /**
     * 排序
     */
    private Integer rank;
    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Long crtTime;
    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Long updTime;
    /**
     * 发布时间
     */
    @Column(name = "publish_time")
    private Long publishTime;
    /**
     * 删除状态 true：正常 1：删除
     */
    @Column(name = "is_del")
    private Boolean isDel;
    /**
     * 创建者id
     */
    @Column(name = "crt_user")
    private Integer crtUser;
    /**
     * 上架状态  上架：true 下架：false
     */
    @Column(name = "on_state")
    private Boolean onState;
    /**
     * 平台 1：欣新房车官网 2：滴房车官网 0:无限制
     */
    private Integer platform;
}
