package com.xxfc.platform.tour.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description 旅游订单列表
 * @data 2019/6/14 15:19
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("旅游订单vo")
public class TourGoodOrderVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 核销订单id
     */
    @ApiModelProperty("核销订单id")
    private Integer id;

    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
     private String name;

    /**
     * 封面
     */
    @ApiModelProperty("封面")
    private String coverUrl;

    /**
     * 出行时间
     */
    @ApiModelProperty("出行时间")
    private String travelTime;

    /**
     * 总人数
     */
    @ApiModelProperty("总人数")
    private int  headCount;

    /**
     * 已上车人数
     */
    @ApiModelProperty("已上车人数")
    private int  tripOfNum;

    /**
     * 未上车人数
     */
    @ApiModelProperty("未上车人数")
    private  int  leaveOfNum;

    /**
     * 是否出行  '状态：0-未出行；1-已出行'
     */
    @ApiModelProperty("出行与否")
    private  Integer  travelStatus;

    /**
     * 开始出行日期
     */
    @JsonIgnore
    private Date startDate;

    /**
     * 开始出行时间
     */
    @JsonIgnore
    private Long startTime;
}
