package com.xxfc.platform.summit.controller;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.summit.biz.ActivityBiz;
import com.xxfc.platform.summit.biz.ActivityBmBiz;
import com.xxfc.platform.summit.entity.Activity;
import com.xxfc.platform.summit.pojo.ActivityQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/front/activity")
@IgnoreUserToken
@IgnoreClientToken
public class FrontActivityController extends BaseController<ActivityBiz, Activity> {


    @Autowired
    private ActivityBmBiz activityBmBiz;

    @Autowired
    private ActivityBiz activityBiz;


    @GetMapping("app/unauth/info")
    public ObjectRestResponse info(
            @RequestParam(value = "activityId",defaultValue = "0")Integer activityId,
            @RequestParam(value = "key",defaultValue = "")String key,
            HttpServletRequest request){

        return activityBmBiz.getActivityById(activityId,key,request);
    }

    @GetMapping("app/unauth/qdLimts")
    public ObjectRestResponse qdLimts(
            @RequestParam(value = "activityId",defaultValue = "0")Integer activityId,
            @RequestParam(value = "latitude", required = false) Double latitude,
            @RequestParam(value = "longitude", required = false) Double longitude){

        return activityBiz.checkQdlimits(latitude,longitude,activityId);
    }





}
