package com.xxfc.platform.summit.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.summit.biz.ActivityBiz;
import com.xxfc.platform.summit.entity.Activity;
import com.xxfc.platform.summit.pojo.ActivityQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/activity")
@Api(tags = "峰会")
public class ActivityController extends BaseController<ActivityBiz, Activity> {


    @PostMapping("/app/unauth/list")
    @ApiOperation(value = "峰会列表",notes = "峰会列表")
    public ObjectRestResponse getList(@RequestBody ActivityQuery query ){
        return ObjectRestResponse.succ(baseBiz.getList(query));
    }

    @Override
    @PutMapping ("/update")
    @ApiOperation(value = "修改",notes = "修改")
    public ObjectRestResponse update(@RequestBody Activity activity ){
        if (baseBiz.update(activity)) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @Override
    @PostMapping("/add")
    @ApiOperation(value = "添加",notes = "添加")
    public ObjectRestResponse add(@RequestBody Activity activity ){
        if (baseBiz.add(activity)) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

}
