package com.xxfc.platform.order.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 租车订单详情
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-19 20:21:29
 */
@Data
@Table(name = "order_rent_vehicle_detail")
public class OrderRentVehicleDetail implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  基础订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "基础订单id")
    private Integer orderId;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  开始时间
     */
    @Column(name = "start_time")
	@ApiModelProperty(value = "开始时间")
    private Long startTime;
	
	    /**
     *  结束时间
     */
    @Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
    private Long endTime;
	
	    /**
     *  天数
     */
    @Column(name = "day_num")
	@ApiModelProperty(value = "天数")
    private Integer dayNum;
	
	    /**
     *  取车地点
     */
    @Column(name = "start_addr")
	@ApiModelProperty(value = "取车地点")
    private String startAddr;
	
	    /**
     *  还车地点
     */
    @Column(name = "end_addr")
	@ApiModelProperty(value = "还车地点")
    private String endAddr;
	
	    /**
     *  车辆id
     */
    @Column(name = "vehicle_id")
	@ApiModelProperty(value = "车辆id")
    private String vehicleId;
	
	    /**
     *  取车城市编号
     */
    @Column(name = "start_city")
	@ApiModelProperty(value = "取车城市编号")
    private Integer startCity;
	
	    /**
     *  还车城市编号
     */
    @Column(name = "end_city")
	@ApiModelProperty(value = "还车城市编号")
    private Integer endCity;
	
	    /**
     *  取车城市名称
     */
    @Column(name = "start_city_name")
	@ApiModelProperty(value = "取车城市名称")
    private String startCityName;
	
	    /**
     *  还车城市名称
     */
    @Column(name = "end_city_name")
	@ApiModelProperty(value = "还车城市名称")
    private String endCityName;
	
	    /**
     *  司机类型 1--公司司机；2--自己司机
     */
    @Column(name = "driver_type")
	@ApiModelProperty(value = "司机类型 1--公司司机；2--自己司机")
    private Integer driverType;
	
	    /**
     *  自己司机ids
     */
    @Column(name = "my_driver_ids")
	@ApiModelProperty(value = "自己司机ids")
    private String myDriverIds;
	
	    /**
     *  出发公司Id
     */
    @Column(name = "start_company_id")
	@ApiModelProperty(value = "出发公司Id")
    private Integer startCompanyId;
	
	    /**
     *  结束公司Id
     */
    @Column(name = "end_company_id")
	@ApiModelProperty(value = "结束公司Id")
    private Integer endCompanyId;
	
	    /**
     *  车型id
     */
    @Column(name = "model_id")
	@ApiModelProperty(value = "车型id")
    private Integer modelId;
	
	    /**
     *  评分人
     */
    @Column(name = "s_userid")
	@ApiModelProperty(value = "评分人")
    private Integer sUserid;
	
	    /**
     *  评分
     */
    @Column(name = "score")
	@ApiModelProperty(value = "评分")
    private Integer score;
	
	    /**
     *  费用明细
     */
    @Column(name = "cost_detail")
	@ApiModelProperty(value = "费用明细")
    private String costDetail;
	
	    /**
     *  押金
     */
    @Column(name = "deposit")
	@ApiModelProperty(value = "押金")
    private BigDecimal deposit;
	
	    /**
     *  评分时间
     */
    @Column(name = "s_time")
	@ApiModelProperty(value = "评分时间")
    private Long sTime;
	
	    /**
     *  交付人id
     */
    @Column(name = "delivery_user")
	@ApiModelProperty(value = "交付人id")
    private Integer deliveryUser;
	
	    /**
     *  交付人名称
     */
    @Column(name = "delivery_name")
	@ApiModelProperty(value = "交付人名称")
    private String deliveryName;
	
	    /**
     *  交付人手机号
     */
    @Column(name = "delivery_phone")
	@ApiModelProperty(value = "交付人手机号")
    private String deliveryPhone;
	
	    /**
     *  交车时间
     */
    @Column(name = "delivery_time")
	@ApiModelProperty(value = "交车时间")
    private Long deliveryTime;
	
	    /**
     *  收车人id
     */
    @Column(name = "collect_user")
	@ApiModelProperty(value = "收车人id")
    private Integer collectUser;
	
	    /**
     *  收车人名称
     */
    @Column(name = "collect_name")
	@ApiModelProperty(value = "收车人名称")
    private String collectName;
	
	    /**
     *  收车人手机号
     */
    @Column(name = "collect_phone")
	@ApiModelProperty(value = "收车人手机号")
    private String collectPhone;
	
	    /**
     *  收车时间
     */
    @Column(name = "collect_time")
	@ApiModelProperty(value = "收车时间")
    private Long collectTime;
	
	    /**
     *  优惠天数
     */
    @Column(name = "free_days")
	@ApiModelProperty(value = "优惠天数")
    private Integer freeDays;
	
	    /**
     *  折扣 80 即 8折
     */
    @Column(name = "rebate")
	@ApiModelProperty(value = "折扣 80 即 8折")
    private Integer rebate;
	
	    /**
     *  出发公司区域id
     */
    @Column(name = "start_zone_id")
	@ApiModelProperty(value = "出发公司区域id")
    private Integer startZoneId;
	
	    /**
     *  剩余需要退还的钱（押金）
     */
    @Column(name = "return_pay_residue")
	@ApiModelProperty(value = "剩余需要退还的钱（押金）")
    private BigDecimal returnPayResidue;

	/**
	 *  预定记录id
	 */
	@Column(name = "book_record_id")
	@ApiModelProperty(value = "预定记录id")
	private Long bookRecordId;

	/**
	 *  是否购买免赔
	 */
	@Column(name = "damage_safe")
	@ApiModelProperty(value = "是否购买免赔")
	private Integer damageSafe;

	/**
	 * 是否处理违章 0--未处理；1--已处理
	 */
	@ApiModelProperty(value = "是否处理违章")
	@Column(name = "handel_violation")
	private Integer handelViolation;

	@ApiModelProperty(value = "是否需要定损 0--不需要； 1--需要定损")
	@Column(name = "fixed_loss_status")
	private Integer fixedLossStatus;

//	/**
//	 * 返还的免费天数
//	 */
//	@ApiModelProperty(value = "返回的免费天数")
//	@Column(name = "back_free_days")
//	Integer backFreeDays;

}
