package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum RefundTypeEnum {
    //退款类型 1--订单款（除去押金）；2--所有押金 3--部分押金（扣除该扣除的 + 保留违章预备金）；4--剩余押金（扣除该扣除的）
    ORDER_FUND(1, "订单款(除去押金)"),
    DEPOSIT(2, "所有押金"),
    PART_DEPOSIT(3, "部分押金（扣除该扣除的 + 保留违章预备金）"),
    RESIDUE_DEPOSIT(4, "剩余押金（扣除该扣除的）"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();
            //Maps.newHashMap();

    static{
        for(RefundTypeEnum enumE : RefundTypeEnum.values()){
            codeAndDesc.put(enumE.getCode(),enumE.getDesc());
        }
    }

    RefundTypeEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}