package com.xxfc.platform.im.entity;

import lombok.Data;

import javax.persistence.*;

@Table(name = "im_question")
@Data
public class ImQuestion {
    @Id
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 手机型号
     */
    private String model;

    /**
     * 添加时间
     */
    private Long time;

    @Column(name = "user_id")
    private Long userId;

    /**
     * 是否显示
     *  1,显示， 0、不显示
     */
    private Integer visible = 1;

    /**
     * 状态
     */
    private Integer state;

    /**
     * 是否删除
     */
    @Column(name = "is_del")
    private Boolean isDel = false;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Long crtTime;
    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Long updTime;

    /**
     * 内容
     */
    private String content;

    private Integer commentCount;

    private Integer praiseCount;

    private String nickname;

    private String picUrl;

}