package com.xxfc.platform.activity.config;

import com.github.wxiaoqi.security.common.config.rabbit.RabbitCommonConfig;
import com.github.wxiaoqi.security.common.config.rabbit.BindDTO;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.*;


/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitActivityConfig extends RabbitCommonConfig {

    public static final String INTEGRAL_QUEUE = "integral_queue";
    public static final String POPULARZIE_0101_QUEUE = "popularzie.0101.queue";
    //新人注册有礼
    public static final String ACTIVITY_NEW_QUEUE = "activity.new.queue";
    public static final String INTEGRAL_HANDLE_QUEUE = "integral_handle_queue";

    //优惠券
    public static final String COUPON_CANCEL_QUEUE = "coupon.cancel.queue";

    static {
        myQueue = new ArrayList<BindDTO>(){{
            add(new BindDTO(INTEGRAL_QUEUE,  ORDER_TOPIC, "order.#"));
            add(new BindDTO(POPULARZIE_0101_QUEUE,  ADMIN_TOPIC, KEY_APPUSER_REGISTER));
            add(new BindDTO(POPULARZIE_0101_QUEUE,  ADMIN_TOPIC, KEY_APPUSER_AUTH));
            add(new BindDTO(ACTIVITY_NEW_QUEUE,  ADMIN_TOPIC, KEY_APPUSER_REGISTER));
            add(new BindDTO(ACTIVITY_NEW_QUEUE,  ADMIN_TOPIC, KEY_APPUSER_AUTH));
            add(new BindDTO(INTEGRAL_HANDLE_QUEUE, INTEGRAL_TOPIC, INTEGRAL_ROUTING_KEY));
            add(new BindDTO(COUPON_CANCEL_QUEUE, ORDER_TOPIC, KEY_ORDER_CANCEL));
        }};
    }

}

