package com.xxfc.platform.activity.biz;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.activity.entity.ActivityRule;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xxfc.platform.activity.entity.ActivityUserJoin;
import com.xxfc.platform.activity.mapper.ActivityUserJoinMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

/**
 * 用户活动参与表
 *
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-16 14:04:22
 */
@Service
@Slf4j
public class ActivityUserJoinBiz extends BaseBiz<ActivityUserJoinMapper,ActivityUserJoin> {

    @Autowired
    ActivityRuleBiz ruleBiz;
    @Autowired
    UserCouponBiz userCouponBiz;

    //注册参与活动
    public  void joinActivity(Integer userId){
        ActivityRule rule=ruleBiz.getActity();
        if(rule==null){
            log.error("----没有开启的活动----");
            return;
        }
        Integer joinNumber=rule.getJoinNumber()==null?0:rule.getJoinNumber();
        Integer number=rule.getNumber()==null?0:rule.getNumber();
        if(joinNumber>=number){
            log.error("----活动已超过参与人数----number==="+number);
            return;
        }
        rule.setJoinNumber(joinNumber+1);
        Integer activityId=rule.getId();
        ActivityUserJoin userJoin=new ActivityUserJoin();
        userJoin.setActivityId(activityId);
        userJoin.setUserId(userId);
        Long num=selectCount(userJoin);
        if(num!=null&&num>0){
            log.error("----用户已经参与活动----userId===="+userId);
            return;
        }
        insertSelective(userJoin);
        ruleBiz.updateById(rule);
    }

    //领取优惠卷
    public ObjectRestResponse receiveCoupn(Integer userId) {
        ActivityRule rule = ruleBiz.getActity();
        if (rule == null) {
            log.error("----没有开启的活动----");
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"没有开启的活动");
        }
        Integer activityId = rule.getId();
        ActivityUserJoin userJoin = new ActivityUserJoin();
        userJoin.setActivityId(activityId);
        userJoin.setUserId(userId);
        userJoin= selectOne(userJoin);
        if (userJoin == null ) {
            log.error("----用户没有此参与活动----userId====" + userId);
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"不是新用户,无法参与此活动");
        }
        if(userJoin.getStatus()!=0){
            log.error("----用户已领取----userId====" + userId);
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"用户已领取");
        }
        String value=rule.getValue();
        JSONObject json=JSONObject.parseObject(value);
        if(json!=null){
            Integer type=json.getInteger("type");
            if(type==1){
                JSONArray array=json.getJSONArray("value");
                if(array.size()>0){
                    for(int i=0;i<array.size();i++){
                       Integer id=array.getJSONObject(i).getInteger("id");
                        userCouponBiz.userLedCoupon(userId,id);
                    }
                }
            }
        }
        userJoin.setStatus(1);
        updateById(userJoin);
        return ObjectRestResponse.succ();
    }

    //判断用户是否已领取或无法领取优惠卷
    public ObjectRestResponse checkUserCoupon(Integer userId){
        ActivityRule rule = ruleBiz.getActity();
        if (rule == null) {
            log.error("----没有开启的活动----");
            return ObjectRestResponse.createFailedResult(101,"无有效活动");
        }
        Integer activityId = rule.getId();
        ActivityUserJoin userJoin = new ActivityUserJoin();
        userJoin.setActivityId(activityId);
        userJoin.setUserId(userId);
        userJoin= selectOne(userJoin);
        if (userJoin == null ) {
            log.error("----用户没有此参与活动----userId====" + userId);
            return ObjectRestResponse.createFailedResult(102,"不是新用户,无法参与此活动");
        }
        if(userJoin.getStatus()!=0){
            log.error("----用户已领取----userId====" + userId);
            return ObjectRestResponse.createFailedResult(103,"用户已领取");
        }
        return  ObjectRestResponse.succ();
    }



}