package com.xxfc.platform.activity.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户与推广活动（邀请有礼）的关系表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-05 15:23:04
 */
@Data
@Table(name = "activity_popularize_user")
public class ActivityPopularizeUser implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  描述、详情等（看情况使用）
     */
    @Column(name = "descr")
	@ApiModelProperty(value = "描述、详情等（看情况使用）")
    private String descr;
	
	    /**
     *  一共需要的进度
     */
    @Column(name = "end_progress")
	@ApiModelProperty(value = "一共需要的进度")
    private Integer endProgress;
	
	    /**
     *  当前进度
     */
    @Column(name = "current_progress")
	@ApiModelProperty(value = "当前进度")
    private Integer currentProgress;
	
	    /**
     *  推广活动id
     */
    @Column(name = "popularize_id")
	@ApiModelProperty(value = "推广活动id")
    private Integer popularizeId;
	
	    /**
     *  已经完成了的项
     */
    @Column(name = "finish_item")
	@ApiModelProperty(value = "已经完成了的项")
    private String finishItem;

	/**
	 *  参与的用户的id
	 */
	@Column(name = "user_id")
	@ApiModelProperty(value = "参与的用户的id")
	private Integer userId;

	/**
	 *  状态 0--未完成；1--完成；-1--失败
	 */
	@Column(name = "status")
	@ApiModelProperty(value = "状态 0--未完成；1--完成；-1--失败")
	private Integer status;

}
