package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.UserBusinessBiz;
import com.github.wxiaoqi.security.admin.bo.PromoteBO;
import com.github.wxiaoqi.security.admin.bo.UserTeamMemberBo;
import com.github.wxiaoqi.security.admin.vo.UserTeamMemberVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/11 17:48
 */
@RestController
@RequestMapping("/team")
public class UserBussinessController {

    @Autowired
   private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

     @Autowired
    private UserBusinessBiz businessBiz;

     @GetMapping("/teams")
     public ObjectRestResponse<UserTeamMemberVo> findTeamPage(@RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize, HttpServletRequest request){
         try {
             IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
             UserTeamMemberVo userTeamMemberVo = businessBiz.findTeamMemberPageByUserId(Integer.valueOf(infoFromToken.getId()), pageNo, pageSize);
             return ObjectRestResponse.succ(userTeamMemberVo);
         } catch (Exception e) {
           throw new BaseException(e);
         }
   }

   @GetMapping("/promote")
   public ObjectRestResponse<PromoteBO>  findPromoteBo(HttpServletRequest request){
       try {
           IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
           PromoteBO promoteBO = businessBiz.getPromoteBoByUserId(Integer.valueOf(infoFromToken.getId()));
           return ObjectRestResponse.succ(promoteBO);
       } catch (Exception e) {
           throw new BaseException(e);
       }
   }
}
