package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.MyWalletDetailBiz;
import com.github.wxiaoqi.security.admin.vo.WalletDetailPageVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/15 9:45
 */
@RestController
@RequestMapping("/walletDetail")
public class MyWalletDetailController {

    @Autowired
    private MyWalletDetailBiz myWalletDetailBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @GetMapping("/page")
    public ObjectRestResponse<PageDataVO<WalletDetailPageVo>> findWalletDetailPage(@RequestParam("pageNo") Integer pageNo,@RequestParam("pageSize") Integer pageSize, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            PageDataVO<WalletDetailPageVo> walletDetailPage = myWalletDetailBiz.findWalletDetailPage(Integer.valueOf(infoFromToken.getId()), pageNo, pageSize);
            return ObjectRestResponse.succ(walletDetailPage);
        } catch (Exception e) {
            throw new BaseException(e);
        }

    }
}
