package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.GroupBiz;
import com.github.wxiaoqi.security.admin.biz.ResourceAuthorityBiz;
import com.github.wxiaoqi.security.admin.biz.UserBiz;
import com.github.wxiaoqi.security.admin.entity.Group;
import com.github.wxiaoqi.security.admin.entity.User;
import com.github.wxiaoqi.security.admin.vo.GroupUsers;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.msg.BaseResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 11:51
 */
@RestController
@RequestMapping("current")
public class CurrentController {
    @Autowired
    private GroupBiz groupBiz;

    @Autowired
    private UserBiz userBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @Autowired
    protected HttpServletRequest request;

    @RequestMapping(value = "/groups", method = RequestMethod.GET)
    public @ResponseBody
    BaseResponse getGroups() throws Exception  {
        String username = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getUniqueName();
        if (username == null) {
            throw new Exception();
        }
        User user = userBiz.getUserByUsername(username);
        if (user == null) {
            throw new Exception();
        }
        return new ObjectRestResponse<Group>().rel(true).data(groupBiz.getUserGroups(user.getId()));
    }
}
