package com.github.wxiaoqi.security.common.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;   
/**  
* @author  
* @version  
*/   
public class SystemProperty { 
	private static final String XML_FILE_EXTENSION = ".xml";
	//读取key
	public static Map<String,String> getValue() throws Exception
	{ 
		Resource resource = new ClassPathResource("/androidver.properties");
		Properties prop = PropertiesLoaderUtils.loadProperties(resource);
		Map<String,String> map = new HashMap<String, String>();
		map.put("versioncode", prop.getProperty("versioncode"));
		map.put("versionname", prop.getProperty("versionname"));
		map.put("downurl", prop.getProperty("downurl"));
		return  map;

	}
	//写key
	public static void setValue(Map<String,String> map) throws Exception
	{
		Resource resource = new ClassPathResource("/androidver.properties");
		System.out.println(resource.getFile().getPath());
		Properties prop = PropertiesLoaderUtils.loadProperties(resource);
		for(Map.Entry<String, String> entry:map.entrySet()){
			prop.setProperty(entry.getKey(), entry.getValue()); 
		}
        OutputStream fos = new FileOutputStream(resource.getFile().getPath());     
        // 以适合使用 load 方法加载到 Properties 表中的格式，   
        // 将此 Properties 表中的属性列表（键和元素对）写入输出流   
        prop.store(fos, null); 
        fos.close();
        
	}
	
	
	//读取key
	public static Map<String,String> getValue_sign() throws Exception
	{
		Resource resource = new ClassPathResource("/androidver_sign.properties");
		Properties prop = PropertiesLoaderUtils.loadProperties(resource);
		Map<String,String> map = new HashMap<String, String>();
		map.put("versioncode", prop.getProperty("versioncode"));
		map.put("versionname", prop.getProperty("versionname"));
		map.put("downurl", prop.getProperty("downurl"));
		return  map;

	}
	//写key
	public static void setValue_sign(Map<String,String> map) throws Exception
	{
		Resource resource = new ClassPathResource("/androidver_sign.properties");
		System.out.println(resource.getFile().getPath());
		Properties prop = PropertiesLoaderUtils.loadProperties(resource);
		for(Map.Entry<String, String> entry:map.entrySet()){
			prop.setProperty(entry.getKey(), entry.getValue()); 
		}
        OutputStream fos = new FileOutputStream(resource.getFile().getPath());     
        // 以适合使用 load 方法加载到 Properties 表中的格式，   
        // 将此 Properties 表中的属性列表（键和元素对）写入输出流   
        prop.store(fos, null); 
        fos.close();
	}
	
	//读取key
	public static String getSystemConfig(String key) throws Exception
	{
		Resource resource = new ClassPathResource("/properties/systemconfig.properties");
		Properties prop = loadProperties(resource);
		return  prop.getProperty(key);

	}

	//读取key
	public static String getResultCod(String key) throws Exception
	{
		Resource resource = new ClassPathResource("/properties/resultcod.properties");
		Properties prop = loadProperties(resource);
		return  prop.getProperty(key);
		
	}

	//读取key
	public static String getScrmservice(String key) throws Exception
	{
		Resource resource = new ClassPathResource("/scrmservice.properties");
		Properties prop = PropertiesLoaderUtils.loadProperties(resource);
		return  prop.getProperty(key);
		
	}
	
	public static String getConfig(String key){
		String config = ""; 
		try {
			config = getSystemConfig(key);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return config;
	}

	public static String getResultConfig(String key){
		String config = ""; 
		try {
			config = getResultCod(key);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return config;
	}


	public static String getScrmConfig(String key){
		String config = ""; 
		try {
			config = getScrmservice(key);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return config;
	}
		
	
	public static Properties loadProperties(Resource resource) throws IOException {
		Properties props = new Properties();
		fillProperties(props, resource);
		return props;
	}

	public static void fillProperties(Properties props, Resource resource) throws IOException {
		InputStream is = resource.getInputStream();
		InputStreamReader reader = new InputStreamReader(is, "UTF-8");
		try {
			String filename = resource.getFilename();
			if (filename != null && filename.endsWith(XML_FILE_EXTENSION)) {
				props.loadFromXML(is);
			}
			else {
				props.load(reader);
			}
		}
		finally {
			is.close();
		}
	}

}   
