/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl;

import java.util.Locale;
import ytx.org.apache.http.HttpResponse;
import ytx.org.apache.http.HttpResponseFactory;
import ytx.org.apache.http.ProtocolVersion;
import ytx.org.apache.http.ReasonPhraseCatalog;
import ytx.org.apache.http.StatusLine;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.impl.EnglishReasonPhraseCatalog;
import ytx.org.apache.http.message.BasicHttpResponse;
import ytx.org.apache.http.message.BasicStatusLine;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Reason phrase catalog must not be null.");
        }
        this.reasonCatalog = catalog;
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        if (ver == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        Locale loc = this.determineLocale(context);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

