/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.dashboard.view;

import com.taobao.csp.sentinel.dashboard.discovery.AppInfo;
import com.taobao.csp.sentinel.dashboard.discovery.AppManagement;
import com.taobao.csp.sentinel.dashboard.view.Result;
import com.taobao.csp.sentinel.dashboard.view.vo.MachineInfoVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/app"}, produces={"application/json"})
public class AppController {
    @Autowired
    AppManagement appManagement;

    @ResponseBody
    @RequestMapping(value={"/names.json"})
    Result<List<String>> queryApps(HttpServletRequest request) {
        return Result.ofSuccess((Object)this.appManagement.getAppNames());
    }

    @ResponseBody
    @RequestMapping(value={"/briefinfos.json"})
    Result<List<AppInfo>> queryAppInfos(HttpServletRequest request) {
        ArrayList list = new ArrayList(this.appManagement.getBriefApps());
        Collections.sort(list, Comparator.comparing(AppInfo::getApp));
        return Result.ofSuccess(list);
    }

    @ResponseBody
    @RequestMapping(value={"/{app}/machines.json"})
    Result<List<MachineInfoVo>> getMachinesByApp(@PathVariable(value="app") String app) {
        AppInfo appInfo = this.appManagement.getDetailApp(app);
        if (appInfo == null) {
            return Result.ofSuccess(null);
        }
        ArrayList list = new ArrayList(appInfo.getMachines());
        Collections.sort(list, (o1, o2) -> {
            int t = o1.getApp().compareTo(o2.getApp());
            if (t != 0) {
                return t;
            }
            t = o1.getIp().compareTo(o2.getIp());
            if (t != 0) {
                return t;
            }
            return o1.getPort().compareTo(o2.getPort());
        });
        return Result.ofSuccess((Object)MachineInfoVo.fromMachineInfoList(list));
    }
}

