package com.xxfc.platform.summit.interceptor;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSON;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.UserAgentUtil;
import com.xxfc.platform.summit.service.WeixinService;
import com.xxfc.platform.summit.vo.UserInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import com.alibaba.fastjson.JSONObject;

import java.io.PrintWriter;


/**
 * 微信登陆拦截器
 * 
 * @author
 *
 */
@Slf4j
public class WeChatH5LoginInterceoptor extends HandlerInterceptorAdapter {

	/**
	 * 微信公众号自动登陆令牌的url参数名
	 */
	public static final String frontSessionKey = "frontWeixKey";

	@Autowired
	WeixinService weixinService;


	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

		String curr_domain = request.getServerName();
		HttpSession session = request.getSession();
		log.info("curr_domain:" + curr_domain);
		log.info("address:" + request.getRequestURL().toString());
		log.info("params:" + request.getQueryString());

		boolean isWx = UserAgentUtil.isWexinBrowser(request);
		if (isWx) {
			String frontSessionValue1 = (String) session.getAttribute(frontSessionKey);
			if (StringUtils.isNotBlank(frontSessionValue1)) {
				 return  true;
			}
			JSONObject json = new JSONObject();
			json.put("status",1001);
			json.put("data","https://dev.dfangche.com/api/summit/auth/app/unauth/wxLogin?redirec_url=https://dev.dfangche.com/h5/appHtml/view/wxh5/index.html");
			response.getWriter().write(json.toJSONString());
			return false;
		}
		return  true;
	}


}
