package com.xxfc.platform.summit.controller;

import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.summit.service.WeixinService;
import com.xxfc.platform.summit.vo.UserInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * @author Administrator
 */
@Controller
@RequestMapping("/auth")
@Slf4j
public class WeixinController {

    public static final String WECHAT_AUTOLOGIN_CALLBACKURL_KEY = "callback";

    @Autowired
    WeixinService weixinService;

    public static final String frontSessionKey = "frontWeixKey";

    @Value("${wx.url}")
    private String  url;



    @RequestMapping(value ="/app/unauth/wxLogin",method = RequestMethod.GET)
    @IgnoreUserToken
    public String index(@RequestParam(value = "redirec_url")String redirec_url){
        log.info("-----微信wxLogin---redirec_url=="+redirec_url);
        if (StringUtils.isBlank(redirec_url)){
            redirec_url="";
        }
        String encrypt_curr_url = Base64.encode(redirec_url);
        redirec_url=url+"?" + WECHAT_AUTOLOGIN_CALLBACKURL_KEY+ "=" + encrypt_curr_url;
        String  oauth_api=weixinService.getAuthorize(redirec_url);
        return  String.format("redirect%s",oauth_api);
    }

    /**
     * 微信浏览器获取用户信息
     * @param code
     * @param callback
     * @return
     */
    @GetMapping(value = "/userInfo")
    public String getUserInformation(String code, String callback, HttpServletRequest request) {
        log.info("-----微信回调userInfo---code=="+code+"----redirec_url==="+callback);
        if (StringUtils.isNotBlank(code)){
            log.info("----code为空---");
            return String.format("code为空");
        }
        JSONObject jsonData = weixinService.getAccessToken(code);
        String openid = jsonData.getString("openid");
        String access_token = jsonData.getString("access_token");
        String refresh_token = jsonData.getString("refresh_token");
        log.info("-----微信回调userInfo---openid=="+openid+"----access_token==="+access_token);
        HttpSession session = request.getSession();
        //验证access_token是否失效
        JSONObject validateData = weixinService.getValidateData(access_token, openid);
        if (!"0".equals(validateData.getString("errcode"))){
            //刷新access_token
            JSONObject refreshData= weixinService.getRefreshToken(refresh_token);
            access_token = refreshData.getString("access_token");
        }
        UserInfo userInfo=new UserInfo();
        userInfo.setOpenId(openid);
        log.error("UserInfo===" + JSONObject.toJSONString(userInfo));
        String encode = Base64.encode(JSONObject.toJSONString(userInfo));
        session.removeAttribute(frontSessionKey);
        session.setAttribute(frontSessionKey, encode);
        callback =Base64.encode(callback);
        log.error("callback===" + callback);
        return  String.format("redirect%s",callback);
    }



}
