package com.github.wxiaoqi.security.admin.rest;

import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.biz.AppUserDetailBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserLoginBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserManageBiz;
import com.github.wxiaoqi.security.admin.constant.Status;
import com.github.wxiaoqi.security.admin.dto.AppUserManageDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.entity.AppUserManage;
import com.github.wxiaoqi.security.admin.entity.User;
import com.github.wxiaoqi.security.admin.vo.AppUserManageVo;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Set;

/**
 * app用户管理类
 * @author Administrator
 */
@RestController
@RequestMapping("appUsersManage")
public class AppUsersManageController extends BaseController<AppUserManageBiz,AppUserManage> {

    @Autowired
    private AppUserLoginBiz appUserLoginBiz;

    @Autowired
    private AppUserDetailBiz appUserDetailBiz;

    @Autowired
    protected UserAuthConfig userAuthConfig;

    @Autowired
    private PublicController publicController;

    @Autowired
    private VehicleFeign vehicleFeign;

    private Integer ALL_PERMISSIONS=1;
    /**
     * 查询所有
     * @return
     */
    @PostMapping("/findAll")
    public ObjectRestResponse<PageInfo<AppUserManageVo>> findAllByQuery(@RequestBody AppUserManageDTO appUserManageDTO) throws Exception {
        String token = userAuthConfig.getToken(request);
        ObjectRestResponse objectRestResponse = publicController.userinfoByToken(token);
        User  user  = (User) objectRestResponse.getData();
        if (user==null){
            throw new BaseException("User error!");
        }
        if (ALL_PERMISSIONS.equals(user.getDataAll())) {
            return ObjectRestResponse.succ(baseBiz.findAllByQuery(appUserManageDTO));
        }
        ObjectRestResponse<Set<Integer>> setObjectRestResponse = vehicleFeign.corporationCity(user.getDataZone(), user.getDataCompany());
        Set<Integer> cityList =  setObjectRestResponse.getData();
        appUserManageDTO.setCitySet(cityList);
        return  ObjectRestResponse.succ(baseBiz.findAllByQueryAndCity(appUserManageDTO));
    }
    /**
     * 查询一条
     * @param id
     * @return
     */
    @GetMapping("/findOneById/{id}")
    public ObjectRestResponse<AppUserVo> findOneById(@PathVariable Integer id){
        return ObjectRestResponse.succ(baseBiz.findOneById(id));
    }

    /**
     * 保存
     * @param appUserVo
     * @return
     */
    @PostMapping("/save")
    public ObjectRestResponse save(@RequestBody AppUserVo  appUserVo){
        baseBiz.save(appUserVo);
        return ObjectRestResponse.succ();
    }

    /**
     * 禁用
     * @param appUserId
     * @return
     */
    @PutMapping("/disable/{appUserId}")
    public ObjectRestResponse disable(@PathVariable("appUserId") Integer appUserId){
        AppUserLogin appUserLogin = new AppUserLogin();
        appUserLogin.setStatus(Status.FORBIDDEN);
        appUserLogin.setId(appUserId);
        appUserLoginBiz.disable(appUserLogin);
        return ObjectRestResponse.succ();
    }

    /**
     * 取消禁用
     * @param appUserId
     * @return
     */
    @PutMapping("/available/{appUserId}")
    public ObjectRestResponse available(@PathVariable("appUserId") Integer appUserId){
        AppUserLogin appUserLogin = new AppUserLogin();
        appUserLogin.setStatus(Status.AVAILABLE);
        appUserLogin.setId(appUserId);
        appUserLoginBiz.available(appUserLogin);
        return ObjectRestResponse.succ();
    }

    /**
     * 删除用户
     * @param id
     * @return
     */
    @DeleteMapping("/deleteById/{id}")
    public ObjectRestResponse deleteById(@PathVariable Integer id){
        appUserLoginBiz.deleteAppUserById(id);
        return ObjectRestResponse.succ();
    }

    @PutMapping("/user_position")
    public ObjectRestResponse<Void> setUserPositionById(@RequestParam("id") Integer id,@RequestParam("positionId") Integer positionId){
         appUserDetailBiz.updateUserPositionByUserId(id,positionId);
        return ObjectRestResponse.succ();
    }
}

