package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户关系表
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-03 16:36:44
 */
@Data
@Table(name = "app_user_relation")
public class AppUserRelation implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  父id
     */
    @Column(name = "parent_id")
	@ApiModelProperty(value = "父id")
    private Integer parentId;
	
	    /**
     *  绑定的来源：1-app；2-小程序
     */
    @Column(name = "bind_type")
	@ApiModelProperty(value = "绑定的来源：1-app；2-小程序")
    private Integer bindType;
	
	    /**
     *  绑定时间
     */
    @Column(name = "bind_time")
	@ApiModelProperty(value = "绑定时间")
    private Long bindTime;
	
	    /**
     *  是否永久绑定关系：0-否；1-是
     */
    @Column(name = "is_forever")
	@ApiModelProperty(value = "是否永久绑定关系：0-否；1-是")
    private Integer isForever;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间")
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;
	

}
