package com.xxfc.platform.activity.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/23 10:55
 */
@Data
public class CouponPagVo {


    @ApiModelProperty("主键id")
    private Integer id;


    @ApiModelProperty(value = "优惠券标题（有图片则显示图片）：无门槛50元优惠券 | 单品最高减2000元")
    private String title;

    @ApiModelProperty(value = "图片")
    private String icon;

    @ApiModelProperty(value = "0-全平台；1-租车；2-旅游；3-营地")
    private Integer channel;

    @ApiModelProperty(value = "1满减券 2叠加满减券 3无门槛券（需要限制大小）")
    private Integer type;

    @ApiModelProperty(value = "用券抵扣金额")
    private BigDecimal usedAmount;


    @ApiModelProperty(value = "配额：发券数量")
    private Integer quota;


    @ApiModelProperty(value = "已领取的优惠券数量")
    private Integer takeCount;


    @ApiModelProperty(value = "已使用的优惠券数量")
    private Integer usedCount;


    @ApiModelProperty(value = "1生效 2失效 3已结束")
    private Integer status;


    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

}
