package com.xxfc.platform.order.pojo.price;

import cn.hutool.core.collection.CollUtil;
import com.xxfc.platform.vehicle.pojo.dto.order.VMCalendarPriceCostDTO;
import lombok.Data;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;

import java.math.BigDecimal;
import java.util.List;

@Data
public class DelayAddPriceVO {
    /**
     * 延期增加的天数
     */
    Integer delayAddDays = 0;

    /**
     * 不计免赔单价
     */
    BigDecimal damageSafePrice = BigDecimal.ZERO;

    /**
     * 延期不记免赔费用
     */
    BigDecimal delayDamageSafeAmount = BigDecimal.ZERO;

    /**
     * 使用（消耗）详情列表
     */
    List<VMCalendarPriceCostDTO> delayAmountList = CollUtil.newArrayList();

    public void initDelayDamageSafeAmount() {
        this.delayDamageSafeAmount = this.damageSafePrice.multiply(new BigDecimal(delayAddDays+ ""));
    }

    public Integer residueDelayFreeDays(Integer realResidueDays) {
        if(realResidueDays > delayAddDays) {
            realResidueDays = delayAddDays;
        }

        //已使用的延长天数
        Integer useDelayDays = delayAddDays - realResidueDays;
        //延长的免费天数
        Integer residueDelayFreeDays = 0;

        List<VMCalendarPriceCostDTO> delayAmountList = getDelayAmountList();
        for(int i = useDelayDays; i < delayAddDays; i++) {
            residueDelayFreeDays += delayAmountList.get(i).getFreeDays();
        }

        return residueDelayFreeDays;
    }

    public BigDecimal delayAddUseAmount(Integer delayAddUseDays) {
        BigDecimal delayUsedAmount = BigDecimal.ZERO;
        if(delayAddUseDays > getDelayAddDays()) {
            delayAddUseDays = getDelayAddDays();
        }

        for(int i = 0; i < delayAddUseDays; i++) {
            delayUsedAmount = delayUsedAmount.add(delayAmountList.get(i).getPrice());
        }

        return delayUsedAmount;
    }

    public BigDecimal delayAddFreeAmount(Integer delayAddUseDays) {
        BigDecimal delayFreeAmount = BigDecimal.ZERO;
        if(delayAddUseDays > getDelayAddDays()) {
            delayAddUseDays = getDelayAddDays();
        }

        for(int i = 0; i < delayAddUseDays; i++) {
            delayFreeAmount = delayFreeAmount.add(delayAmountList.get(i).getFreeAmount());
        }

        return delayFreeAmount;
    }
}
