package com.xxfc.platform.order.pojo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Data
@ApiModel("订单业绩明细表")
public class Achievement implements Serializable {
    private static final Map<Integer, String> orderTypeMap = new HashMap<>();
    private static final Map<Integer, String> payWayMap = new HashMap<>();

    static {
        orderTypeMap.put(1, "租车");
        orderTypeMap.put(2, "旅游");
        orderTypeMap.put(3, "会员");
        payWayMap.put(null, "微信");
        payWayMap.put(1, "微信支付");
        payWayMap.put(2, "支付宝支付");
        payWayMap.put(3, "银联支付");
    }

    @ApiModelProperty(value = "下单用户真实姓名")
    private String realname;
    @ApiModelProperty(value = "用户手机号")
    private String username;
    @ApiModelProperty(value = "上级姓名")
    private String parentRealname;
    @ApiModelProperty(value = "上级职位")
    private String positionName;
    @ApiModelProperty(value = "上级手机号")
    private String parentUsername;
    @ApiModelProperty(value = "订单所属公司id")
    private Integer companyId;
    @ApiModelProperty(value = "订单所属公司名")
    private String companyName;
    @ApiModelProperty(value = "优惠价格")
    private BigDecimal favorablePrice = BigDecimal.ZERO;
    @ApiModelProperty(value = "创建时间", hidden = true)
    @Column(name = "crt_time")
    private String crtTime;
    @ApiModelProperty(value = "订单号")
    private String no;
    @ApiModelProperty(value = "订单类型")
    private Integer type;
    @Column(name = "order_amount")
    @ApiModelProperty("订单总额")
    private BigDecimal orderAmount = BigDecimal.ZERO;
    @ApiModelProperty(value = "实际订单额")
    @Column(name = "real_amount")
    private BigDecimal realAmount = BigDecimal.ZERO;
    @Column(name = "pay_way")
    @ApiModelProperty(value = "支付方式")
    private Integer payWay;

    public void setCrtTime(Date crtTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.crtTime = dateFormat.format(crtTime);
    }

    public String getType() {
        return orderTypeMap.get(type);
    }

    public String getPayWay() {
        return payWayMap.get(payWay);
    }
}
