package com.xxfc.platform.order.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/26 15:43
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "center_order_profile_display")
@Entity
public class CenterOrderProfileDisplay implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator = "JDBC")
    private Integer id;
    /**
     * 区域id
     */
    @Column(name = "area_id")
    private Integer areaId;
    /**
     * 区域名称
     */
    @Column(name = "area_name")
    private String areaName;
    /**
     * 区域订单金额
     */
    @Column(name = "area_amount")
    private BigDecimal areaAmount;
}
