package com.xxfc.platform.activity.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.ActivityAttendanceRecordBiz;
import com.xxfc.platform.activity.bo.ActivityAttendanceRecordBo;
import com.xxfc.platform.activity.dto.ActivityAttendanceRecordFindDTO;
import com.github.wxiaoqi.security.common.exception.BaseException;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/4 14:56
 */
@RestController
@RequestMapping("admin/activityAttendanceRecord")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class ActivityAttendanceRecordAdminController {
   private final ActivityAttendanceRecordBiz activityAttendanceRecordBiz;

   @PostMapping("/page")
   public ObjectRestResponse<ActivityAttendanceRecordBo> listActivityAttendanceRecordWithPage(@RequestBody ActivityAttendanceRecordFindDTO activityAttendanceRecordFindDTO){
       ActivityAttendanceRecordBo activityAttendanceRecordBo = activityAttendanceRecordBiz.listActivityAttendanceRecord(activityAttendanceRecordFindDTO);
       return ObjectRestResponse.succ(activityAttendanceRecordBo);
   }

   @PostMapping("/export")
    public void exportActivityAttendanceRecordData(@RequestBody ActivityAttendanceRecordFindDTO activityAttendanceRecordFindDTO, HttpServletResponse response){
       try {
           String name = DateTimeFormatter.ofPattern("YYYYMMddHHmmss").format(LocalDateTime.now());
           response.setContentType("application/vnd.ms-excel;charset=utf-8");
           String filename = String.format("%s-activity-attendance-record.xlsx",name);
           response.setHeader("Content-Disposition","attachment;filename="+ new String(filename.getBytes(), "iso8859-1"));
           ServletOutputStream outputStream = response.getOutputStream();
           activityAttendanceRecordBiz.exportActivityAttendanceRecordData(activityAttendanceRecordFindDTO,outputStream);
           response.setCharacterEncoding("UTF-8");
       }catch (Exception ex){
           throw  new BaseException("导出数据失败");
       }
   }
}