package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.vehicle.biz.BranchCompanyStockRightBiz;
import com.xxfc.platform.vehicle.biz.BranchCompanyStockService;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.BranchCompanyStockApplyInfo;
import com.xxfc.platform.vehicle.pojo.BranchCompanyStockApplyVo;
import com.xxfc.platform.vehicle.pojo.BranchCompanyStockSearchVo;
import com.xxfc.platform.vehicle.pojo.vo.BranchCompanyStockInfoRightVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

@RestController
@IgnoreClientToken
@IgnoreUserToken
@RequestMapping("branchCompany/stock/right")
public class BranchCompanyStockRightController extends BaseController<BranchCompanyStockRightBiz> {

    private static Integer MAX_DRIVING_LICENSE_SIZE  = 10*1024*1024;//10M

    @Autowired
    BranchCompanyStockService branchCompanyStockService;

    /**
     * 分页获取
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("page")
    public RestResponse page(Integer page, Integer limit) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(baseBiz.selectAll(page, limit));
    }

    /**
     * 搜索
     * @param searchVo
     * @return
     */
    @GetMapping("search")
    public RestResponse search(BranchCompanyStockSearchVo searchVo) {
        if (searchVo.getPage() == null || searchVo.getLimit() == null) {
            searchVo.setPage(1);
            searchVo.setLimit(10);
        }
        return RestResponse.suc(baseBiz.search(searchVo));
    }

    @GetMapping("{id}")
    public RestResponse get(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(branchCompanyStockService.selectById(id));
    }

    @GetMapping("info/{id}")
    public RestResponse getInfo(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(branchCompanyStockService.getInfoById(id));
    }

    /**
     * 更新
     * @return
     */
    @RequestMapping(value ="/updStockInfo",method = RequestMethod.POST)
    public ObjectRestResponse updStockInfo(@RequestBody BranchCompanyStockInfoRightVo stockInfoVo) {
        if (stockInfoVo==null||stockInfoVo.getCompanyId()==null||stockInfoVo.getCompanyId()==0 || stockInfoVo.getTotal() == null || stockInfoVo.getPrice() == null) {
             return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"参数不能为空");
        }
        return baseBiz.updStockInfo(stockInfoVo);
    }

    /**
     * 更新
     * @return
     */
    @RequestMapping(value ="/addStockInfo",method = RequestMethod.POST)
    public ObjectRestResponse addStockInfo(@RequestBody BranchCompanyStockInfoRightVo stockInfoVo) {
        if (stockInfoVo==null||stockInfoVo.getCompanyId()==null||stockInfoVo.getCompanyId()==0|| stockInfoVo.getTotal() == null || stockInfoVo.getPrice() == null) {
            return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"参数不能为空");
        }
        return baseBiz.updStockInfo(stockInfoVo);
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @DeleteMapping("{id}")
    public ObjectRestResponse delete(@PathVariable("id") Integer id) {
         baseBiz.delete(id);
        return ObjectRestResponse.succ();
    }

    @RequestMapping(value ="/upload/companyPic",method = RequestMethod.POST)
    public RestResponse uploadCompanyPic(@RequestParam("file") MultipartFile file)
            throws Exception{
        String contentType = file.getContentType();   //图片文件类型
        if(!contentType.equals("image/jpeg") && !contentType.equals("image/gif")){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        if(file.getSize() > MAX_DRIVING_LICENSE_SIZE){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return branchCompanyStockService.uploadCompanyPic(file);
    }

    @IgnoreUserToken
    @RequestMapping(value="/download/companyPic",method=RequestMethod.GET)
    public ResponseEntity<byte[]> downloadDrivingLicense(@RequestParam("realFileRelPath") String realFileRelPath) throws Exception {
        return branchCompanyStockService.downloadCompanyPic(realFileRelPath);
    }

    /**
     * 申请购买
     * @param applyVo
     * @return
     */
    @PostMapping("apply")
    public RestResponse apply(@RequestBody BranchCompanyStockApplyVo applyVo) {
        if (applyVo.getCompanyId() == null || applyVo.getName() == null || applyVo.getTel() == null || applyVo.getCount() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.apply(applyVo);
        return RestResponse.suc();
    }

    @GetMapping("apply/page")
    public RestResponse applyPage(Integer page, Integer limit) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(branchCompanyStockService.selectApplyAll(page, limit));
    }

    @GetMapping("apply/{id}")
    public RestResponse getApplyById(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(branchCompanyStockService.getApplyById(id));
    }

    @PutMapping("apply")
    public RestResponse updateApply(BranchCompanyStockApplyInfo applyInfo) {
        if (applyInfo.getId() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.updateApply(applyInfo);
        return RestResponse.suc();
    }

    @DeleteMapping("apply/{id}")
    public RestResponse deleteApply(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.deleteApply(id);
        return RestResponse.suc();
    }

    /**
     * 取消申请，放弃购买
     * @return
     */
    @PostMapping("apply/cancel")
    public RestResponse cancel(Integer applyId) {
        if (applyId == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.cancelApply(applyId);
        return RestResponse.suc();
    }

    /**
     * 确认购买，减库存
     */
    @PostMapping("apply/buy")
    public RestResponse buy(Integer applyId) {
        if (applyId == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.buy(applyId);
        return RestResponse.suc();
    }

    @GetMapping("allPrice")
    public RestResponse getAllPrice() {
        return RestResponse.suc(branchCompanyStockService.getAllPrice());
    }


    /**
     * 导入
     * @param multipartfile
     * @param request
     * @return
     */
    @PostMapping("importExcel")
    public RestResponse importExcel(@RequestParam(value = "file") MultipartFile multipartfile,
                                    HttpServletRequest request) {
        return branchCompanyStockService.importExcel(multipartfile,request);
    }

}
