package com.xxfc.platform.vehicle.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.google.common.collect.Maps;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.VehicleBookHourInfo;
import com.xxfc.platform.vehicle.mapper.VehicleBookHourInfoMapper;
import com.xxfc.platform.vehicle.pojo.VehicleBookHourInfoDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class VehicleBookHourInfoBiz extends BaseBiz<VehicleBookHourInfoMapper, VehicleBookHourInfo> {

    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");

    public  Map<String, Integer>  getPredictableHours(String bookStartDate, String bookEndDate, Boolean notCheckTimeLegal) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = null;
        Date endDate = null;
        try{
            startDate = simpleDateFormat.parse(bookStartDate);
            endDate = simpleDateFormat.parse(bookEndDate);
        }catch (Exception e) {
            e.printStackTrace();
        }

        //判定时间是否合法
        if(!Boolean.TRUE.equals(notCheckTimeLegal)) {
            if (bookStartDate.compareTo(DateTime.now().toString(DEFAULT_DATE_TIME_FORMATTER)) < 0) {
                throw new BaseException(ResultCode.ONLY_BOOK_FROM_TODAY);
            }
        }
        if (bookStartDate.compareTo(bookEndDate) > 0) {
            throw new BaseException(ResultCode.END_TIME_FROM_TODAY);
        }
        Map<String, Integer> predictableHours = Maps.newHashMap();
        //预定开始小时
        int hour = new DateTime(startDate).hourOfDay().get();
        int endHour = new DateTime(endDate).hourOfDay().get();
        //获取开始天的预定小时
        int startPredictableHour = 0;
        if(hour > 0 ) {
            for (int curentHour = hour; curentHour <= 24; curentHour++) {
                startPredictableHour |= 1 << (curentHour - 1);
            }
        }

        //获取结束天的预定小时
        int endPredictableHour = 0;
        if(endHour > 0) {
            for (int curentHour = 0; curentHour < endHour; curentHour++) {
                endPredictableHour |= 1 << (curentHour);
            }
        }
        if(DateTime.parse(bookStartDate, DEFAULT_DATE_TIME_FORMATTER).toString(DATE_TIME_FORMATTER).equals(DateTime.parse(bookEndDate, DEFAULT_DATE_TIME_FORMATTER).toString(DATE_TIME_FORMATTER))) {//同一天预定
            predictableHours.put(DateTime.parse(bookStartDate, DEFAULT_DATE_TIME_FORMATTER).toString(DATE_TIME_FORMATTER), startPredictableHour & endPredictableHour);
        } else {
            predictableHours.put(DateTime.parse(bookStartDate, DEFAULT_DATE_TIME_FORMATTER).toString(DATE_TIME_FORMATTER), startPredictableHour);
            predictableHours.put(DateTime.parse(bookEndDate, DEFAULT_DATE_TIME_FORMATTER).toString(DATE_TIME_FORMATTER), endPredictableHour);
        }
        DateTime startDay = DateTime.parse(DateTime.parse(bookStartDate, DEFAULT_DATE_TIME_FORMATTER).toString(DATE_TIME_FORMATTER), DATE_TIME_FORMATTER);
        DateTime endDay = DateTime.parse(DateTime.parse(bookEndDate, DEFAULT_DATE_TIME_FORMATTER).toString(DATE_TIME_FORMATTER), DATE_TIME_FORMATTER);
        if(endDay.getDayOfMonth() - startDay.getDayOfMonth() >1){ //
            for (DateTime curDate = startDay.plusDays(1); curDate.compareTo(endDay) < 0; curDate = curDate.plusDays(1)) {
                String curDateStr = curDate.toString(DATE_TIME_FORMATTER);
                //全天预定
                predictableHours.put(curDateStr, 16777215);
            }
        }
        return predictableHours;
    }

    public List<VehicleBookHourInfo> selectByVehicleAndDate(VehicleBookHourInfoDto vehicleBookHourInfoDto) {
        return mapper.selectByVehicleAndDate(vehicleBookHourInfoDto);
    }

    @Cache(key = "vehicle.hourInfo")
    public VehicleBookHourInfo selectByVehicleAndId(VehicleBookHourInfoDto vehicleBookHourInfoDto) {
        return mapper.selectByVehicleAndId(vehicleBookHourInfoDto);
    }

    @Cache(key = "vehicle.hourInfo")
    public List<VehicleBookHourInfo> getAll() {
        return mapper.selectAll();
    }

    @Transactional
    @CacheClear(key = "vehicle.hourInfo")
    public ObjectRestResponse save(VehicleBookHourInfoDto vehicleBookHourInfoDto) {
        if(vehicleBookHourInfoDto == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        List<VehicleBookHourInfo> vehicleBookHourInfos = mapper.selectByVehicleAndDate(vehicleBookHourInfoDto);
        //有数据直接更新
        if(vehicleBookHourInfos.size() >=1) {
            for(VehicleBookHourInfo vehicleBookHourInfo : vehicleBookHourInfos) {
                if(vehicleBookHourInfo.getBookedHour().equals(vehicleBookHourInfoDto.getBookedHour())) {
                    return ObjectRestResponse.createFailedResult(ResCode.VEHICLE_IS_BOOKED_TODAY.getCode(), ResCode.VEHICLE_IS_BOOKED_TODAY.getDesc());
                } else {
                    vehicleBookHourInfo.setBookedHour(vehicleBookHourInfo.getBookedHour() | vehicleBookHourInfoDto.getBookedHour());
                    updateSelectiveByIdRe(vehicleBookHourInfo);
                }
            }
            return ObjectRestResponse.succ();
        }
        //没有数据直接添加
        insertSelectiveRe(vehicleBookHourInfoDto);
        return ObjectRestResponse.succ();
    }

    /**
     * 删除预定车辆小时记录信息
     * @param vehicleId 车辆Id
     * @param dateList  日期列表
     * @return
     */
    @Transactional
    @CacheClear(key = "vehicle.hourInfo")
    public ObjectRestResponse delete(String vehicleId, List<String> dateList) {
            if(StringUtils.isBlank(vehicleId) || dateList.size() <= 0) {
                return ObjectRestResponse.paramIsEmpty();
            }
            Map<String, Object> param = Maps.newHashMap();
            param.put("vehicleId", vehicleId);
            param.put("list", dateList);
            List<VehicleBookHourInfo> list = mapper.selectByVehicleAndDateList(param);
            list.forEach((a) -> mapper.delete(a));
         return ObjectRestResponse.succ();
    }

    public static void main(String[] args) throws Exception{
        int b = 16744448;
        Integer a = b | 48;
        System.out.println(a);
    }

}
