package com.xxfc.platform.vehicle.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.Utils.OrderDateUtils;
import com.xxfc.platform.vehicle.entity.BranchCompanyVehicleCount;
import com.xxfc.platform.vehicle.mapper.BranchCompanyVehicleCountMapper;
import com.xxfc.platform.vehicle.pojo.BranchCompanyVehicleCountVo;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyVehicleCountDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class BranchCompanyVehicleCountBiz extends BaseBiz<BranchCompanyVehicleCountMapper, BranchCompanyVehicleCount> {

	@Autowired
	VehicleBiz vehicleBiz;
	public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");


	public ObjectRestResponse add(BranchCompanyVehicleCount branchCompanyVehicleCount) {
		if (branchCompanyVehicleCount == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		BranchCompanyVehicleCount oldValue = selectOne(branchCompanyVehicleCount);
		if (oldValue == null) {
			insertSelectiveRe(branchCompanyVehicleCount);
		}
		return ObjectRestResponse.succ();
	}

	public ObjectRestResponse addAll(List<BranchCompanyVehicleCountVo> list) {
		if (list != null && list.size() > 0) {
			list.parallelStream().forEach(result -> {
				BranchCompanyVehicleCount branchCompanyVehicleCount = new BranchCompanyVehicleCount();
				BeanUtil.copyProperties(result, branchCompanyVehicleCount, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
				add(branchCompanyVehicleCount);
			});
			return ObjectRestResponse.succ();
		} else {
			return ObjectRestResponse.paramIsEmpty();
		}
	}
	@Scheduled(cron = "0 0 2 * * *")
	public void addAll() {
		addAll(vehicleBiz.getAllVehicleInfo());
	}


	/**
	 * 按天统计
	 * @param query
	 * @return
	 */
	public PageDataVO<BranchCompanyVehicleCountVo> countByDay(Query query) {
		return PageDataVO.pageInfo(query, () -> mapper.getAllCountInfo(query.getSuper()));
	}
	/**
	 * 按月统计
	 * @param query
	 * @return
	 */
	public PageDataVO<BranchCompanyVehicleCountVo> countByMonth(Query query) {
		return PageDataVO.pageInfo(query, () -> mapper.countByMonth(query.getSuper()));
	}
	/**
	 * 按周统计
	 * @param query
	 * @return
	 */
	public PageDataVO<BranchCompanyVehicleCountVo> countByWeek(Query query) {
		return PageDataVO.pageInfo(query, () -> mapper.countByWeek(query.getSuper()));
	}

	public ObjectRestResponse<PageDataVO<BranchCompanyVehicleCountVo>> getAllCountInfo(BranchCompanyVehicleCountDTO branchCompanyVehicleCountDTO) {
		if (branchCompanyVehicleCountDTO == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		Integer page = branchCompanyVehicleCountDTO.getPage() == null ? 1 : branchCompanyVehicleCountDTO.getPage();
		Integer limit = branchCompanyVehicleCountDTO.getLimit() == null ? 10 : branchCompanyVehicleCountDTO.getLimit();
		Integer type = branchCompanyVehicleCountDTO.getType() == null ? 1 : branchCompanyVehicleCountDTO.getType();
		branchCompanyVehicleCountDTO.setPage(page);
		branchCompanyVehicleCountDTO.setLimit(limit);
		if (StringUtils.isBlank(branchCompanyVehicleCountDTO.getStartTime()) || StringUtils.isBlank(branchCompanyVehicleCountDTO.getEndTime())) {
			branchCompanyVehicleCountDTO.setStartTime(DateTime.now().minusDays(1).toString(DATE_TIME_FORMATTER));
			branchCompanyVehicleCountDTO.setEndTime(DateTime.now().minusDays(1).toString(DATE_TIME_FORMATTER));
		}
		Query query = new Query(branchCompanyVehicleCountDTO);
		if (type == 1) {//按天
			return ObjectRestResponse.succ(countByDay(query));
		}
		if (type == 2) {//按周
			PageDataVO<BranchCompanyVehicleCountVo> pageDataVO = countByWeek(query);
			if (pageDataVO != null && pageDataVO.getData() != null && pageDataVO.getData().size() > 0) {
				pageDataVO.getData().parallelStream().forEach(result -> {
					String weekStartDate = OrderDateUtils.getStartDayOfWeekNo(result.getCountYear(), result.getCountWeek());
					String weekEndDate = OrderDateUtils.getEndDayOfWeekNo(result.getCountYear(), result.getCountWeek());
					result.setWeekStartDate(weekStartDate);
					result.setWeekEndDate(weekEndDate);
				});
			}
			return ObjectRestResponse.succ(pageDataVO);
		}
		if (type == 3) {//按月
			return ObjectRestResponse.succ(countByMonth(query));
		}
		return ObjectRestResponse.succ(new PageDataVO<>());
	}


	public List<BranchCompanyVehicleCountVo> exportAllDate(BranchCompanyVehicleCountDTO branchCompanyVehicleCountDTO) {
		Integer type = branchCompanyVehicleCountDTO.getType() == null ? 1 : branchCompanyVehicleCountDTO.getType();
		Map<String, Object> param = new HashMap<>();
		if (branchCompanyVehicleCountDTO.getCompanyId() != null) {
			param.put("companyId", branchCompanyVehicleCountDTO.getCompanyId());
		}
		if (type == 1) {//按天
			return mapper.getAllCountInfo(param);
		}
		if (type == 2) {//按周
			List<BranchCompanyVehicleCountVo> pageDataVO = mapper.countByWeek(param);
			if (pageDataVO != null &&  pageDataVO.size() > 0) {
				pageDataVO.parallelStream().forEach(result -> {
					String weekStartDate = OrderDateUtils.getStartDayOfWeekNo(result.getCountYear(), result.getCountWeek());
					String weekEndDate = OrderDateUtils.getEndDayOfWeekNo(result.getCountYear(), result.getCountWeek());
					result.setWeekStartDate(weekStartDate);
					result.setWeekEndDate(weekEndDate);
				});
			}
			return pageDataVO;
		}
		if (type == 3) {//按月
			return mapper.countByMonth(param);
		}
		return new ArrayList<>();
	}

}
