package com.xxfc.platform.order.entity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author Administrator
 */

@Data
@ApiModel(value = "历史订单统计实体")
public class OrderStatistics {




    /**
     * 历史交总金额
     */
    @ApiModelProperty(value = "历史交总金额")
    private BigDecimal totalGmv;

    /**
     * 历史押金总额
     */
    @ApiModelProperty(value = "历史押金总额")
    private BigDecimal totalSecurityDeposit;

    /**
     * 历史退还押金总额
     */
    @ApiModelProperty(value = "历史退还押金总额")
    private BigDecimal totalRefundSecurityDeposit;

    /**
     * 历史赔偿总额
     */
    @ApiModelProperty(value = "历史赔偿总额")
    private BigDecimal totalCompensation;

    /**
     * 历史违章总额
     */
    @ApiModelProperty(value = "历史违章总额")
    private BigDecimal totalForfeit;


    /**
     * 历史订单退款
     */
    @ApiModelProperty(value = "历史订单退款")
    private BigDecimal totalReturnGmv;

    /**
     * 历史延期扣款总额
     */
    @ApiModelProperty(value = "历史延期扣款总额")
    private BigDecimal totalDefaultMoney;

    /**
     * 历史实际消费总额
     */
    @ApiModelProperty(value = "实际消费总额")
    private BigDecimal totalExpenditure;
}
