package com.xinxincaravan.caravan.vehicle.constant;

import com.google.common.collect.Maps;

import java.util.Map;

public enum BookType {
    USER_RENT(1,"用户租赁"),
    EMPLOYEE_APPLY(2,"内部员工申请"),
    REPAIRING(3,"维修"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = Maps.newHashMap();

    static{
        for(BookType constantType : BookType.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    BookType(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
