package com.xinxincaravan.caravan.vehicle.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.xinxincaravan.caravan.vehicle.entity.VehicleUpkeepItem;
import com.xinxincaravan.caravan.vehicle.mapper.BranchCompanyStockApplyInfoMapper;
import com.xinxincaravan.caravan.vehicle.mapper.VehicleUpkeepItemMapper;
import com.xinxincaravan.caravan.vehicle.mapper.VehicleUpkeepLogMapper;
import com.xinxincaravan.caravan.vehicle.vo.VehicleUpkeepLogItemVo;
import com.xinxincaravan.caravan.vehicle.vo.VehicleUpkeepLogVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class VehicleUpkeepService {

    @Autowired
    VehicleUpkeepItemMapper vehicleUpkeepItemMapper;

    @Autowired
    VehicleUpkeepLogMapper vehicleUpkeepLogMapper;

    public List<VehicleUpkeepItem> getAllItem() {
        return vehicleUpkeepItemMapper.selectAll();
    }

    public PageInfo<VehicleUpkeepItem> pageItem(Integer page, Integer limit) {
        PageHelper.startPage(page, limit);
        return new PageInfo<>(vehicleUpkeepItemMapper.selectAll());
    }

    public void addItem(String itemName) {
        VehicleUpkeepItem item = new VehicleUpkeepItem();
        item.setName(itemName);
        vehicleUpkeepItemMapper.insert(item);
    }

    public void updateItem(VehicleUpkeepItem item) {
        vehicleUpkeepItemMapper.updateByPrimaryKey(item);
    }

    public void deleteItem(Integer id) {
        vehicleUpkeepItemMapper.deleteByPrimaryKey(id);
    }

    public PageInfo<VehicleUpkeepLogVo> pageLog(String numberPlate, Integer page, Integer limit, List<Integer> companyList) {
        PageHelper.startPage(page, limit);
        return new PageInfo<>(vehicleUpkeepLogMapper.selectVoAll(numberPlate,companyList));
    }

    public VehicleUpkeepLogVo getLogVoById(Integer id) {
        VehicleUpkeepLogVo vehicleUpkeepLogVo = vehicleUpkeepLogMapper.selectVoById(id);
        List<VehicleUpkeepLogItemVo> upkeepItems = vehicleUpkeepLogMapper.getItemsByLogId(id);
        vehicleUpkeepLogVo.setUpkeepItems(upkeepItems);
        return vehicleUpkeepLogVo;
    }

    public void deleteLog(Integer id) {
        vehicleUpkeepLogMapper.deleteByPrimaryKey(id);
        vehicleUpkeepLogMapper.deleteItemsByLogId(id);
    }
}
