package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.vehicle.biz.VehicleBiz;
import com.xxfc.platform.vehicle.biz.VehicleDepartureService;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.VehicleDepartureLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Map;

import static com.xxfc.platform.universal.constant.DictionaryKey.RESERVE;
import static com.xxfc.platform.universal.constant.DictionaryKey.VEHICE_ORDER;

@IgnoreClientToken
@RestController
@RequestMapping("departure")
public class VehicleDepartureController {

    @Autowired
    VehicleDepartureService vehicleDepartureService;
    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    UserFeign userFeign;

    @Autowired
    ThirdFeign thirdFeign;

    @Autowired
    private UserAuthConfig userAuthConfig;

    /**
     * @param numberPlate 车牌
     * @param code        车辆编码
     * @param
     * @param departureId 出发分公司id
     * @param page
     * @param limit
     * @param request
     * @return
     */
    @GetMapping("page")
    public RestResponse page(String numberPlate,
                             @RequestParam(value = "code", required = false) Integer code, String startTime, String endTime,
                             @RequestParam(value = "zoneId", required = false) Integer zoneId,
                             @RequestParam(value = "departureId", required = false) Integer departureId,
                             @RequestParam(value = "use", required = false) String use,
                             @RequestParam(value = "arrivalBranchCompanyId", required = false) Integer arrivalBranchCompanyId,
                             Integer page, Integer limit, HttpServletRequest request) {


        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
        if (userDTO != null) {
            if (userDTO.getDataAll() == 2) {
                List<Integer> companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
                return RestResponse.data(vehicleDepartureService.pageNotAllData(numberPlate, code, zoneId, departureId, arrivalBranchCompanyId, use, startTime, endTime, page, limit, companyList));
            }
        }
        return RestResponse.suc(vehicleDepartureService.page(numberPlate, code, zoneId, departureId, arrivalBranchCompanyId, use, startTime, endTime, page, limit));
    }

    @GetMapping("small/page")
    @IgnoreUserToken
    public RestResponse pageBySmall(String numberPlate, @RequestParam(value = "code", required = false) Integer code, String startTime, String endTime, Integer page, Integer limit, Integer uid, HttpServletRequest request) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        UserDTO userDTO = userFeign.userinfoByUid(uid).getData();
        if (userDTO != null) {
            if (userDTO.getDataAll() == 2) {
                List<Integer> companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
                return RestResponse.data(vehicleDepartureService.pageNotAllData(numberPlate, code, null, null, null, null, startTime, endTime, page, limit, companyList));
            }
        }
        return RestResponse.suc(vehicleDepartureService.page(numberPlate, code, null, null, null, null, startTime, endTime, page, limit));
    }

    /**
     * 根据车辆id查询并分页
     *
     * @param vehicleId
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("findByVehicle")
    public RestResponse findByVehicle(String vehicleId, Integer page, Integer limit) {
        if (vehicleId == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(vehicleDepartureService.findByVehicle(vehicleId, page, limit));
    }

    @GetMapping("statistic")
    public RestResponse statistic(String numberPlate) {
        if (numberPlate == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(vehicleDepartureService.statistic(numberPlate));
    }

    /**
     * 保存
     *
     * @param vehicleDepartureLog
     * @return
     */
    @PostMapping("/app/save")
    public ObjectRestResponse save(@RequestBody VehicleDepartureLog vehicleDepartureLog) {
        return vehicleDepartureService.save(vehicleDepartureLog);
    }


    /**
     * 查询一条
     *
     * @param vid 车辆id
     * @return
     * @throws Exception
     */
    @GetMapping("/app/findOne/{id}")
    public ObjectRestResponse findOne(@PathVariable Integer vid) throws Exception {
        return vehicleDepartureService.findOne(vid);
    }


    /**
     * 收车
     *
     * @param vdl
     * @return
     * @throws Exception
     */
    @PutMapping("/app/collect")
    public ObjectRestResponse collect(@RequestBody VehicleDepartureLog vdl) throws Exception {
        return vehicleDepartureService.collect(vdl);
    }

    /**
     * 车辆用途字典查询
     */
    @GetMapping("findReserveType")
    public ObjectRestResponse<OrderPageVO> getOrderDetail() {
        Map<String, Dictionary> dictionaryMap = thirdFeign.dictionaryGetAll4Map().getData();
        String reserveType = dictionaryMap.get(VEHICE_ORDER + "_" + RESERVE).getDetail();
        return ObjectRestResponse.succ(reserveType);
    }


}
