package com.xxfc.platform.campsite.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 店铺与类型
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@Table(name = "campsite_shop_tag")
public class CampsiteShopTag implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 首页banner图主键
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("首页banner图主键")
    private Long id;

    /**
     * 店铺id
     */
    @Column(name = "shop_id")
    @ApiModelProperty(value = "店铺id")
    private Integer shopId;

    /**
     * 类型id
     */
    @Column(name = "tag_id")
    @ApiModelProperty(value = "类型id")
    private Integer tagId;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

    /**
     * 修改时间
     */
    @Column(name = "upd_time")
    @ApiModelProperty(value = "修改时间", hidden = true)
    private Long updTime;

    /**
     * 是否删除，0否，1是
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除，0否，1是")
    private Integer isDel;


}
