package com.xxfc.platform.uccn.biz;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.xxfc.platform.uccn.comstnt.UrlType;
import com.xxfc.platform.uccn.entity.Article;
import com.xxfc.platform.uccn.mapper.ArticleMapper;
import com.xxfc.platform.uccn.vo.ArticleQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.security.SecureRandom;
import java.util.*;


/**
 * @author Administrator
 */
@Service
public class ArticleBiz extends BaseBiz<ArticleMapper, Article> {
    /**
     * 随机文章条数
     */
    private final Integer RANDOM_NUMBER = 2;

    /**
     * 首页文章条数
     */
    private final Integer HOME_PAGE_NUMBER = 4;




    /**
     * 文章列表
     *
     * @param page
     * @param limit
     * @param type
     * @return
     */
    public PageInfo getArticleList(Integer page, Integer limit, Integer type) {
        PageHelper.startPage(page, limit);
        List articleList = mapper.getArticleList(type,null,null);
        return PageInfo.of(articleList);
    }

    /**
     * 获取一条数据
     *
     * @param id
     * @param urlType
     * @return
     */
    public Article getOne(Integer id, Integer urlType) {

        Example example = new Example(Article.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("id", id);
        criteria.andEqualTo("isDel", 0);
        if (UrlType.OFFICIAL_WEBSITE.getCode().equals(urlType)) {
            criteria.andEqualTo("status", 1);
        }
        Article article = mapper.selectOneByExample(example);
        return article;
    }


    /**
     * 随机获取三条连续的文章
     *
     *
     *
     * @param type
     * @param id
     * @return
     */
    public List getThree( Integer type, Integer number, Integer id) {
        number = number == null ? RANDOM_NUMBER : number;
        List<Article> articleList = mapper.getArticleList(type,null,id);
        if (!Objects.isNull(articleList)) {
            int size = articleList.size();
            if (number >= size) {
                return articleList;
            } else {
                Random random = new Random();
                int r = random.nextInt(size - number + 1);
                List<Article> result = new ArrayList<>();
                for (int i = 0; i < number.intValue(); i++) {
                    int index = i + r;
                    result.add(articleList.get(index));
                }
                return result;
            }
        }
        return new ArrayList();
    }


    /**
     * 首页文章列表
     *
     * @param type
     * @return
     */
    public List getHomePageArticle(Integer type) {
        List<Article> articleList = mapper.getArticleList(type,HOME_PAGE_NUMBER,null);
//        if (Objects.isNull(articleList)) {
//            return new ArrayList();
//        } else {
//            if (articleList.size() > HOME_PAGE_NUMBER) {
//                return articleList.subList(0, HOME_PAGE_NUMBER);
//            } else {
        return articleList;
//            }
//        }
    }

    /**
     * 添加文章
     * @param article
     */
    @Transactional(rollbackFor = Exception.class)
    public void add(Article article) {
        if (article == null) {
            return;
        }

        article.setIsDel(0);
        if (article.getStatus() == null) {
            article.setStatus(0);
        }
        if (article.getType() == null) {
            article.setType(0);
        }

        if (article.getTagTitle()==null||article.getKeywords()==null||article.getDescription()==null) {
            throw  new BaseException("必须设置seo");
        }

        if (article.getStatus()==1){
            article.setAddTime(new Date());
        }
        article.setCreTime(new Date());
        mapper.insertSelective(article);

    }

    /**
     * 后台文章列表
     * @param query
     * @return
     */
    public PageInfo findAll(ArticleQuery query) {
        PageHelper.startPage(query.getPage(),query.getLimit());
        Example exa = Example.builder(Article.class).where(
                WeekendSqls.<Article>custom()
                        .andEqualTo(Article::getIsDel,0)
        ).orderByAsc("weight").orderByDesc("addTime").build();
        List<Article> articles = mapper.selectByExample(exa);

        return PageInfo.of(articles);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateSelectiveByIdRe(Article article){
        article.setUpdTime(new Date());
        if (article.getTagTitle()==null||article.getKeywords()==null||article.getDescription()==null) {
            throw  new BaseException("必须设置seo");
        }
        return mapper.updateByPrimaryKeySelective(article);
    }

    /**
     * 上架
     * @param id
     * @return
     */
    public int putaway(Integer id) {
        Article article = new Article();
        article.setId(id);
        article.setUpdTime(new Date());
        article.setAddTime(new Date());
        article.setStatus(1);
        return mapper.updateByPrimaryKeySelective(article);
    }

    /**
     * 下架
     * @param id
     * @return
     */
    public int soldOut(Integer id) {
        Article article = new Article();
        article.setId(id);
        article.setUpdTime(new Date());
        article.setStatus(0);
        return mapper.updateByPrimaryKeySelective(article);
    }

    /**
     * 删除
     * @param id
     * @return
     */
    public int remove(Integer id) {
        Article article = new Article();
        article.setId(id);
        article.setUpdTime(new Date());
        article.setIsDel(1);
        return mapper.updateByPrimaryKeySelective(article);


    }
}
