package com.xxfc.platform.vehicle.mapper;


import com.xxfc.platform.vehicle.entity.VehiclePublishGoods;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePublishGoodsVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.additional.idlist.SelectByIdListMapper;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

public interface VehiclePublishGoodsMapper extends Mapper<VehiclePublishGoods>, SelectByIdListMapper<VehiclePublishGoods,Integer> {


    List<VehiclePublishGoodsVo> selectList(VehiclePublishFindDTO publishFindDTO);


    List<VehiclePublishGoodsVo> selectListByOrderNo(VehiclePublishFindDTO publishFindDTO);

    @Select("SELECT r.publish_goods_id as id,IFNULL(COUNT(r.id),0) as receiveNumber  FROM vehicle_publish_receive r \n" +
            "\n" +
            "LEFT JOIN vehicle_publish_goods  g ON r.publish_goods_id = g.id\n" +
            "\n" +
            "WHERE g.publish_id=#{publishId} and r.`status` in (1,3) and r.is_del = 0\n" +
            "\n" +
            "GROUP BY r.publish_goods_id")
    List<VehiclePublishGoods> groupGoodsIdList(@Param("publishId") Integer publishId );

    @Select("SELECT g.* FROM vehicle_publish_goods  g\n" +
            "\n" +
            "LEFT JOIN vehicle_publish p ON g.publish_id=p.id\n" +
            "\n" +
            "WHERE g.vehicle_id = #{vehicleId} and p.`status` in (0,2)")
    VehiclePublishGoods getGoodsByVehicleId(@Param("vehicleId")String vehicleId);

}