package com.xxfc.platform.vehicle.mapper;


import com.xxfc.platform.vehicle.entity.VehicleApply;
import com.xxfc.platform.vehicle.pojo.dto.VehicleApplyFindDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleApplyVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.additional.idlist.SelectByIdListMapper;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;

public interface VehicleApplyMapper extends Mapper<VehicleApply>, SelectByIdListMapper<VehicleApply,Integer> {

     List<VehicleApplyVo> selectList(VehicleApplyFindDTO vehicleApplyFindDTO);

    @Select("SELECT * FROM  vehicle_apply WHERE vehicle_id=#{vehicleId} and form_type=2 and is_del = 0 ORDER BY upd_time DESC LIMIT 1")
    VehicleApply getOneByOrderUpdTime(@Param("vehicleId") String vehicleId);

    List<VehicleApplyVo> selectListByApp(VehicleApplyFindDTO vehicleApplyFindDTO);


    @Select("SELECT * FROM vehicle_apply WHERE `apply_status`  = 0  AND DATE_SUB(CURDATE(),INTERVAL 7 DAY) >= date(from_unixtime(crt_time/1000))")
    List<VehicleApply> getListByDay();

}