package com.xxfc.platform.vehicle.pojo.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description 订单评价vo
 * @data 2019/6/18 15:26
 */
@Data
public class VehicleUserScoreVo {

    /**
     *  主键id
     */
    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private String userId;

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名")
    private String userName;

    /**
     * 用户头像地址
     */
    @ApiModelProperty(value = "用户头像地址")
    private String headUrl;

    /**
     *  评分类型
     */
    @ApiModelProperty(value = "评分类型")
    private Integer type;

    /**
     *  评价分
     */
    @ApiModelProperty(value = "评价分")
    private Integer aveScore;


    /**
     *  是否匿名；0-否；1-是
     */
    @ApiModelProperty(value = "是否匿名；0-否；1-是")
    private Integer isAnony;

    /**
     *  评价
     */
    @ApiModelProperty(value = "评价")
    private String comment;

    /**
     *  图片
     */
    @ApiModelProperty(value = "图片")
    private String imgs;

    /**
     * 车型名称
     */
    @ApiModelProperty(value ="车型名称")
    private String modelName;

    /**
     * 车型关键标签
     */
    @ApiModelProperty(value = "车型关键标签")
    private String modelKeyWorld;

    /**
     *  创建时间
     */
    @ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;

    /**
     * 类型-评分
     */
    private List<ScoreTypeVo> scoreTypeVos;
}
