package com.xxfc.platform.vehicle.pojo.vo;


import com.xxfc.platform.vehicle.entity.VehiclePublish;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class VehiclePublishVo extends VehiclePublish {


    @ApiModelProperty("店铺名称")
    String companyName;


    @ApiModelProperty("需求商品")
    List<VehiclePublishGoodsVo> publishGoodsVos;


    @ApiModelProperty("状态描述")
    String statusStr;


    public  String getStatusStr(){
        Integer status = getStatus() == null ? 0 : getStatus();
        if (status.equals(1) || status.equals(3)){
            statusStr = "已结束";
        }else if (status.equals(2)){
            statusStr = "待收藏";
        }else if (status.equals(0)){
            if (getConfirmNumber() != null && getConfirmNumber() > 0){
                statusStr = "已接"+getConfirmNumber()+"辆";
            }else {
                statusStr = "接单中";
            }
        }
        return  statusStr;
    }

}
