package com.xxfc.platform.vehicle.pojo.dto;


import com.github.wxiaoqi.security.common.vo.DataInter;
import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/23 16:27
 */
@Data
public class VehicleFindAppDTO extends PageParam implements DataInter {


    @ApiModelProperty("商品Id")
    private String vehicleId;


    @ApiModelProperty("商品名称")
    private String  name;


    @ApiModelProperty("商品类型 1--房车；2--机车；3--游艇")
    private Integer  goodsType;

    @ApiModelProperty("状态：1-上架；2-下架")
    private Integer  state;

    @ApiModelProperty("品牌id")
    private Integer  brandId;


    @ApiModelProperty("型号id")
    private Integer  categoryId;


    @ApiModelProperty("店铺id")
    private Integer  branchId;

    @ApiModelProperty("是否全网最低价")
    private Integer  isMinPrice;


    List<Integer> dataCorporationIds;

    List<Integer> dataCompanyIds;

    Integer bizType;

    @ApiModelProperty("经度")
    Double lon;
    @ApiModelProperty("纬度")
    Double lat;

    /**
     * 所属市区（id）
     */
    private Integer addrCity;

}
