package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;


/**
 * 商品发布需求表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
@Table(name = "vehicle_publish")
public class VehiclePublish implements Serializable {
	private static final long serialVersionUID = 1L;
	

    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;


	@Column(name = "company_id")
	@ApiModelProperty(value = "店铺id")
	private Integer companyId;


    @Column(name = "type")
	@ApiModelProperty(value = "类型：1-我要车；2-我有车")
    private Integer type;
	

    @Column(name = "goods_type")
	@ApiModelProperty(value = "商品类型 1--房车；2--机车；3--游艇；4-豪车")
    private Integer goodsType;
	

    @Column(name = "number")
	@ApiModelProperty(value = "总商品数")
    private Integer number;


	@Column(name = "confirm_number")
	@ApiModelProperty(value = "已确认商品数量")
	private Integer confirmNumber;



	@Column(name = "wait_confirm_number")
	@ApiModelProperty(value = "待确认商品数量")
	private Integer waitConfirmNumber;


	@Column(name = "publish_end_time")
	@ApiModelProperty(value = "需求结束时间")
	private Long publishEndTime;


	@Column(name = "start_time")
	@ApiModelProperty(value = "开始时间")
	private Long startTime;


	@Column(name = "end_time")
	@ApiModelProperty(value = "结束时间")
	private Long endTime;


	@Column(name = "status")
	@ApiModelProperty(value = "状态：0-发布中；1-已取消；2-待收车,3-已完成")
	private Integer status;


	@Column(name = "remarks")
	@ApiModelProperty(value = "备注")
	private String remarks;
	

    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;


    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;


	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常；1-删除")
	private Integer isDel;

	@Transient
	@ApiModelProperty(value = "调出信息")
	private List<VehiclePublishGoods> publishGoodsList;
	

}
