package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.biz.TourGoodVerificationBiz;
import com.xxfc.platform.tour.common.TourBaseController;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.tour.vo.TourGoodOrderVo;
import com.xxfc.platform.tour.vo.TourVerificationInfoVo;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.auth.common.constatns.CommonConstants.DATA_ALL_FALSE;

@RestController
@RequestMapping("/verfication")
@IgnoreClientToken
public class TourVerificationController extends TourBaseController<TourGoodVerificationBiz> {

    @Autowired
    VehicleFeign vehicleFeign;

    @GetMapping("/getList")
    public ObjectRestResponse getList(TourVerificationInfoVo tourVerificationInfoVo){
       Integer companyId=tourVerificationInfoVo.getCompanyId();
        if (companyId==null){
            UserDTO userDTO=userinfoByToken();
            if ( userDTO!=null&&DATA_ALL_FALSE.equals(userDTO.getDataAll())) {
                List<BranchCompany> companyList= vehicleFeign.companyAll(userDTO.getDataAll(),userDTO.getDataCompany(),userDTO.getDataZone());
                if (companyList.size()>0){
                    List<Integer> companyIds = companyList.stream().map(BranchCompany::getId).collect(Collectors.toList());
                    tourVerificationInfoVo.setCompanyList(companyIds);
                }
            }
        }
        return baseBiz.getVerificationList(tourVerificationInfoVo);
    }

    @GetMapping("/info/{id}")
    public ObjectRestResponse getList(@PathVariable Integer id){
        return baseBiz.getVerification(id);
    }

}