package com.xxfc.platform.order.rest.background;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.ace.cache.annotation.Cache;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.AssertUtils;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.DataInter;
import com.github.wxiaoqi.security.common.vo.DataInterBean;
import com.xxfc.platform.order.biz.*;
import com.xxfc.platform.order.contant.enumerate.DepositRefundStatus;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.RefundStatusEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.entity.OrderStatistics;
import com.xxfc.platform.order.pojo.MembersOrderDto;
import com.xxfc.platform.order.pojo.OrderQuery;
import com.xxfc.platform.order.pojo.order.OrderFullDTO;
import com.xxfc.platform.order.pojo.order.OrderFullVO;
import com.xxfc.platform.vehicle.constant.RedisKey;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("/background/statistics")
@Api(description = "每月总的订单统计")
public class BgStatisticsController extends BaseController<OrderStatisticsBiz, OrderStatistics> implements UserRestInterface {

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    UserFeign userFeign;

    @Autowired
    VehicleFeign vehicleFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    @GetMapping("/indexOrder")
    @ApiOperation(value = "首页订单统计")
    public ObjectRestResponse<IndexOrderVO> indexOrder()  {
        //获取当前用户所在的公司
        if (StrUtil.isBlank(getCurrentUserId())) {
            throw new BaseException(ResultCode.AJAX_WECHAT_NOTEXIST_CODE);
        }
        DataInterBean dataInterBean = getDataInter();

        //获取公司对应的车的id
        String companyIds = StrUtil.join(",", dataInterBean.getDataCompanyIds());
        String timeStr = DatePattern.NORM_DATETIME_MINUTE_FORMAT.format(new DateTime());
        if(companyIds == null || "null".equals(companyIds)) {
            companyIds = "0";
        }
        ObjectRestResponse<List<Vehicle>> feignResponse = vehicleFeign.vehicleSelectByCompanyIds(companyIds);
        List<String> vehicleIds = feignResponse.getData().parallelStream().map(Vehicle::getId).collect(Collectors.toList());

        //获取会员订单统计信息
        return ObjectRestResponse.succ(baseBiz.handleStatistics(companyIds, timeStr, vehicleIds));
    }

    @Data
    public static class IndexOrderVO {
        private BigDecimal currDayOrderAmount;
        private Long currDayOrderNum;
        private Long currDayToLiftVehicleNum;
        private Long currDayToReturnVehicleNum;
        private Long toDealTrafficPay;
    }
}
