package com.xxfc.platform.order.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.entity.CenterOrderProfileDisplay;
import com.xxfc.platform.order.mapper.CenterOrderProfileDisplayMapper;
import com.xxfc.platform.order.pojo.vo.CenterOrderProfileDisplayVo;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/26 15:48
 */
@Transactional(rollbackFor = Exception.class)
@Service
@RequiredArgsConstructor(onConstructor =@__(@Autowired))
public class CenterOrderProfileDisplayBiz extends BaseBiz<CenterOrderProfileDisplayMapper, CenterOrderProfileDisplay> {

    public List<CenterOrderProfileDisplayVo> findCenterOrderProfileDisplays(){
        List<CenterOrderProfileDisplayVo> centerOrderProfileDisplayVos = new ArrayList<>();
        List<CenterOrderProfileDisplay> centerOrderProfileDisplays = mapper.selectAll();
        if (CollectionUtils.isEmpty(centerOrderProfileDisplays)){
            return centerOrderProfileDisplayVos;
        }
        return JSON.parseObject(JSON.toJSONString(centerOrderProfileDisplays),new TypeReference<List<CenterOrderProfileDisplayVo>>(){});
    }
}
