package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 订单人身保险
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-26 18:56:21
 */
@Data
@Table(name = "order_person_insurance")
public class OrderPersonInsurance implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  基础订单id
     */
    @Column(name = "order_id")
	@ApiModelProperty(value = "基础订单id")
    private Integer orderId;
	
	    /**
     *  姓名
     */
    @Column(name = "name")
	@ApiModelProperty(value = "姓名")
    private String name;
	
	    /**
     *  身份证号码
     */
    @Column(name = "id_card")
	@ApiModelProperty(value = "身份证号码")
    private String idCard;
	
	    /**
     *  订单的天数
     */
    @Column(name = "order_day")
	@ApiModelProperty(value = "订单的天数")
    private Integer orderDay;
	
	    /**
     *  保险的天数
     */
    @Column(name = "insurance_day")
	@ApiModelProperty(value = "保险的天数")
    private Integer insuranceDay;
	
	    /**
     *  金额
     */
    @Column(name = "amount")
	@ApiModelProperty(value = "金额")
    private BigDecimal amount;
	
	    /**
     *  状态 1--已支付；2--已退款
     */
    @Column(name = "status")
	@ApiModelProperty(value = "状态 1--已支付；2--已退款")
    private Integer status;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  创建者id
     */
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建者id")
    private String crtUser;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Date updTime;
	
	    /**
     *  更新者id
     */
    @Column(name = "upd_user")
	@ApiModelProperty(value = "更新者id")
    private String updUser;
	

}
