package com.xxfc.platform.order.bo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description 大屏展示的基础数据
 * @data 2019/12/24 16:21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LargeScreenDisplayConstantDataBo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 订单金额基础金额
     */
    private BigDecimal baseOrderAmount = BigDecimal.ZERO;
    /**
     * 订单基础单量
     */
    private int baseOrderNum;
    /**
     * 当日基础订单量
     */
    private long baseTodayOrderNum;
    /**
     * 当日基础金额
     */
    private BigDecimal baseTodayOrderAmount = BigDecimal.ZERO;
    /**
     * 微信支付占比率
     */
    private double wxPayRatio;
    /**
     * 支付宝支付占比率
     */
    private double aliPayRatio;
    /**
     * 安卓终端支付占比率
     */
    private double androidPayRatio;
    /**
     * ios终端支付占比率
     */
    private double iosPayRatio;

}
