package com.xxfc.platform.app.rest;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.app.biz.BannerBiz;
import com.xxfc.platform.app.entity.vo.BannerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description TODO
 * @data 2019/6/26 10:29
 */
@RestController
@RequestMapping("/banner")
public class BannerController {

    @Autowired
    private BannerBiz bannerBiz;

    /**
     * 查询banner图
     *
     * @return
     */
    @GetMapping("/app/unauth/findBannerlist")
    public ObjectRestResponse findBannerlist(@RequestParam(required = false, value = "type") Integer type,
                                             @RequestParam(required = false, value = "location") Integer location,
                                             @RequestParam(required = false, value = "multiLocation") String multiLocation,
                                             @RequestParam(value = "platform",required = false,defaultValue = "0") Integer platform,
                                             @RequestParam(value = "status",required = false,defaultValue = "1") Integer status) {
        if (null == location && StrUtil.isBlank(multiLocation)) {
            return ObjectRestResponse.createDefaultFail();
        }
        List<BannerVo> bannerList = bannerBiz.findBannerList(type, location, multiLocation, platform, status);
        return ObjectRestResponse.succ(bannerList);
    }
}
