package com.xxfc.platform.app.rest;

import com.ace.cache.annotation.CacheClear;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.app.biz.AppVersionMarkBiz;
import com.xxfc.platform.app.entity.AppVersionMark;
import com.xxfc.platform.app.entity.dto.AppVersionMarkDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import static com.xxfc.platform.app.biz.AppVersionMarkBiz.FAIL_OPERATION_CODE;
import static com.xxfc.platform.app.biz.AppVersionMarkBiz.SUCCESSFUL_OPERATION_CODE;

/**
 * @program: ace-security
 * @author: zyh
 * @create: 2020-01-10 11:24
 **/
@IgnoreUserToken
@RestController
@Slf4j
@RequestMapping("version/mark")
public class AppVersionMarkController extends BaseController<AppVersionMarkBiz, AppVersionMark> {

    @Autowired
    private AppVersionMarkBiz appVersionMarkBiz;

    /**
     * @Description: 新增APP版本标识
     * @Param: AppVersionMarkDTO appVersionMarkDTO
     * @return:
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @PostMapping("/appMarkVersionAdd")
    @CacheClear
    public ObjectRestResponse addAppVersionMark(@RequestBody AppVersionMarkDTO appVersionMarkDTO) {
        try {
            Integer status = SUCCESSFUL_OPERATION_CODE;
            String message = "";
            Map<Integer, String> mapStatus = appVersionMarkBiz.addAppVersionMark(appVersionMarkDTO);
            Iterator<Integer> iter = mapStatus.keySet().iterator();
            while (iter.hasNext()) {
                status = iter.next();
                message = mapStatus.get(status);
            }
            if (status.equals(FAIL_OPERATION_CODE)) {
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, message);
            }
            return ObjectRestResponse.succ();
        } catch (Exception e) {
            log.error("新增失败[{}]", e);
            throw new BaseException("新增失败");
        }
    }

    /**
     * @Description: app版本标识 更新以及删除
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @PostMapping("updAppMark")
    @CacheClear
    public ObjectRestResponse updAppVersionMark(@RequestBody AppVersionMarkDTO appVersionMarkDTO) {
        try {
            Map<Integer, String> map = appVersionMarkBiz.updAppVersionMark(appVersionMarkDTO);
            Iterator<Integer> iter = map.keySet().iterator();
            Integer status = 1;
            String message = "";
            while (iter.hasNext()) {
                status = iter.next();
                message = map.get(status);
            }
            if (status.equals(1)) {
                return ObjectRestResponse.succ();
            } else {
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, message);
            }
        } catch (Exception e) {
            log.error("更新失败[{}]", e);
            throw new BaseException("更新失败");
        }
    }


    /**
     * @Description: 页面展示
     * @Param: AppVersionMarkQuery query 业务需求：暂时没有查询框
     * @return: listJson
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @GetMapping("/findAllByQuery")
    public ObjectRestResponse findAllByQuery(@RequestParam(value = "page", defaultValue = "1") Integer page,
                                             @RequestParam(value = "limit", defaultValue = "10") Integer limit,
                                             @RequestParam(value = "mark", defaultValue = "") String mark) {
        Example example = new Example(AppVersionMark.class);
        if (StringUtils.isNotBlank(mark)) {
            example.createCriteria().andLike("mark", "%" + mark + "%");
        }
        example.createCriteria().andEqualTo("isDel", 0);
        example.setOrderByClause("`crt_time` desc");
        PageHelper.startPage(page, limit);
        List<AppVersionMark> listPage = appVersionMarkBiz.selectByExample(example);
        return ObjectRestResponse.succ(PageInfo.of(listPage));
    }

    /**
     * @Description: 單獨查詢，根据标识
     * @Param: MARK標識
     * @return: list
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @GetMapping("/findVersionAppMark")
    public ObjectRestResponse findAllByQuery(@RequestParam("mark") String mark) {
        return ObjectRestResponse.succ(appVersionMarkBiz.findVersionAppMark(mark));
    }


    /**
     * @Description: 会员页面查询注册来源 下拉框接口
     * @Param:
     * @return: list（mark名称）
     * @Author: zyh
     * @Date: 2020/1/13
     */
    @GetMapping("/find/listMark")
    public ObjectRestResponse findListVersionAppMark() {
        return ObjectRestResponse.succ(appVersionMarkBiz.findListVersionAppMark());
    }


}
