package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.biz.ActivityLuckyDrawBiz;
import com.xxfc.platform.activity.entity.ActivityLuckyDraw;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/3 16:51
 */

@RestController
@RequestMapping("activityLuckyDraw")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class ActivityLuckyDrawController {
   private final ActivityLuckyDrawBiz activityLuckyDrawBiz;

   /**
    * 报名
    * @param activityLuckyDraw
    * @param appUserDTO
    * @return
    */
   @PostMapping("/sign_up")
   public ObjectRestResponse<Void> signUP(@RequestBody ActivityLuckyDraw activityLuckyDraw, AppUserDTO appUserDTO){
      activityLuckyDraw.setUserId(appUserDTO.getUserid());
      activityLuckyDraw.setPhone(appUserDTO.getUsername());
      activityLuckyDrawBiz.signUp(activityLuckyDraw);
      return ObjectRestResponse.succ();
   }


}