package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.biz.ActivityBiz;
import com.xxfc.platform.activity.biz.ActivityTypeBiz;
import com.xxfc.platform.activity.dto.ActivityDTO;
import com.xxfc.platform.activity.entity.Activity;
import com.xxfc.platform.activity.vo.ActivityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("app/activity")
public class ActivityController extends BaseController<ActivityBiz, Activity> {


    @Autowired
    ActivityTypeBiz activityTypeBiz;



    @GetMapping("app/unauth/selectList")
    @IgnoreUserToken
    public ObjectRestResponse<PageDataVO<ActivityVo>> selectList( ActivityDTO activityDTO) {
        activityDTO.setTime(System.currentTimeMillis());
        return baseBiz.getAllByPage(activityDTO);
    }



    @GetMapping("app/unauth/typeList")
    @IgnoreUserToken
    public ObjectRestResponse typeList() {
        return ObjectRestResponse.succ(activityTypeBiz.getList());
    }


    @GetMapping("selectListByUserId")
    public ObjectRestResponse<PageDataVO<ActivityVo>> selectListByUserId( ActivityDTO activityDTO) {
        activityDTO.setUserId(getCurrentUserIdInt());
        return baseBiz.getAllByPage(activityDTO);
    }


    @GetMapping("app/unauth/info")
    @IgnoreUserToken
    public ObjectRestResponse<ActivityVo> info( ActivityDTO activityDTO) {
        return ObjectRestResponse.succ(baseBiz.getActivityInfo(activityDTO));
    }

    @PostMapping("add")
    public ObjectRestResponse<PageDataVO<ActivityVo>> selectList( @RequestBody  Activity activity) {
        activity.setUserId(getCurrentUserIdInt());
        baseBiz.insertSelective(activity);
        return ObjectRestResponse.succ();
    }


}