package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.AppraiseLabelInfoBiz;
import com.github.wxiaoqi.security.admin.dto.AppraiseLabeInfoDTO;
import com.github.wxiaoqi.security.admin.dto.CompanyApplyFindDTO;
import com.github.wxiaoqi.security.admin.entity.AppraiseLabelInfo;
import com.github.wxiaoqi.security.admin.entity.CompanyInfo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("backstage/appraiseLabelInfo")
public class AdminAppraiseLabelInfoController extends BaseController<AppraiseLabelInfoBiz, AppraiseLabelInfo> {

    @GetMapping("tag/selectList")
    @ApiModelProperty("标签列表")
    public ObjectRestResponse applySelectList(AppraiseLabeInfoDTO appraiseLabeInfoDTO) {
        return  baseBiz.selectList(appraiseLabeInfoDTO);
    }

    @PostMapping("tag/upd")
    @ApiModelProperty("修改标签")
    public  ObjectRestResponse upd(@RequestBody AppraiseLabelInfo appraiseLabelInfo) {
        baseBiz.saveOrUpd(appraiseLabelInfo);
        return ObjectRestResponse.succ();
    }
}